RaytracingAccelerationStructure accelStructure : register(t0, space0);
RWTexture2D<float4> outTexture : register(u0, space1);

struct RayPayload
{
    float4 color;
};

[shader("raygeneration")]
void MainRayGen()
{
    uint uavW;
    uint uavH;
    outTexture.GetDimensions(uavW, uavH);
    
    uint2 rayIndex = DispatchRaysIndex().xy;
    
    if ( rayIndex.x < uavW && rayIndex.y < uavH )
    {
        uint2 rayDimensions = (float2)DispatchRaysDimensions();
        
        RayDesc r;
        r.Origin = float3(0, 0, 0);
        r.Direction = float3( float2(rayIndex)/float2(rayDimensions) * 2.0 - 1.0, -1.0 );
        r.Direction.y *= -1.0;
        r.TMin = 0.04;
        r.TMax = 100.0;
        
        RayPayload payload;
        payload.color = float4(1.0, 0, 0.0, 0);
        
        uint instanceMask = 255;
        uint rayContribToHG = 0;
        uint geomMultiplier = 1;
        uint missShaderIndex = 0;
        TraceRay(accelStructure,
                 RAY_FLAG_NONE,
                 instanceMask,
                 rayContribToHG,
                 geomMultiplier,
                 missShaderIndex,
                 r,
                 payload);
        
        outTexture[rayIndex.xy] = payload.color;
    }
}

[shader("miss")]
void MainMiss(inout RayPayload payload)
{
    payload.color = float4(1, 0, 1, 0);
}
