#ifndef ACCELSTRUCTUREBUILDER_HPP
#define ACCELSTRUCTUREBUILDER_HPP

#include <Foundation/Foundation.hpp>
#include <Metal/Metal.hpp>

#include <vector>
#include <functional>

struct AccelerationStructureWithResources
{
    MTL::AccelerationStructure* pAccelStructure;
    NS::Array* pIndirectResources;
};

MTL::AccelerationStructure* newPrimitiveAccelerationStructure(MTL::Device* pDevice,
                                                              MTL::CommandQueue* pCommandQueue,
                                                              const NS::Array* geometryDescriptors);

MTL::AccelerationStructure* newInstanceAcceleartionStructure(MTL::Device* pDevice,
                                                             MTL::CommandQueue* pCommandQueue,
                                                             const std::vector<MTL::AccelerationStructure*>& primitiveStructures,
                                                             const std::vector<MTL::AccelerationStructureInstanceDescriptor>& instances);

AccelerationStructureWithResources newAccelerationStructure(MTL::Device* pDevice,
                                                            MTL::CommandQueue* pCommandQueue,
                                                            const NS::Array* geometryDescriptors,
                                                            const std::vector<MTL::AccelerationStructureInstanceDescriptor>& instances);

void releaseAccelerationStructureWithResources(AccelerationStructureWithResources* pAccelStructureWithResources);

#endif // ACCELSTRUCTUREBUILDER_HPP
